var Eventable = function(){
	this._eventableEventListeners = {};
};

Eventable.prototype.addEventListener = function(type,cb){
	if(!this._eventableEventListeners[type])
		this._eventableEventListeners[type]=[];
	
	for(var i=0;i<this._eventableEventListeners[type].length;i++)
		if(this._eventableEventListeners[type][i]==cb)
			return;
	this._eventableEventListeners[type].push(cb);
};

Eventable.prototype.removeEventListener = function(type,cb){
	if(!this._eventableEventListeners[type])
		return;
		
	for(var i=0;i<this._eventableEventListeners[type].length;i++)
		if(
			this._eventableEventListeners[type][i]==cb
			|| (
				(this._eventableEventListeners[type][i] instanceof Bound)
				&& this._eventableEventListeners[type][i].func == cb
			)
		){
			this._eventableEventListeners[type].splice(i,1);
			return;
		}
	
	return;
};

Eventable.prototype.dispatchEvent = function(type,evt){
	if(!this._eventableEventListeners[type])
		return;
		
	for(var i=0;i<this._eventableEventListeners[type].length;i++)
		this._eventableEventListeners[type][i].call(null,evt);

};

Eventable.prototype._eventableEventListeners = null;
